/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import fi.dy.masa.minihud.util.LightLevelRenderCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class OverlayRendererLightLevel
extends OverlayRendererBase {
    public static final OverlayRendererLightLevel INSTANCE = new OverlayRendererLightLevel();
    private static final class_2960 TEXTURE_NUMBERS = class_2960.method_60655((String)"minihud", (String)"textures/misc/light_level_numbers.png");
    private final List<LightLevelInfo> lightInfos = new ArrayList<LightLevelInfo>();
    private class_2338.class_2339 mutablePos = new class_2338.class_2339();
    private class_2350 lastDirection = class_2350.field_11043;
    private boolean tagsBroken;
    private boolean needsUpdate;
    private boolean hasData = false;

    protected OverlayRendererLightLevel() {
    }

    @Override
    public String getName() {
        return "LightLevel";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
        this.clearBuffers();
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_LIGHT_LEVEL.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > 4.0 || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > 4.0 || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > 4.0 || Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() && this.lastDirection != entity.method_5735();
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null) {
            this.needsUpdate = false;
            return;
        }
        class_2338 pos = PositionUtils.getEntityBlockPos((class_1297)entity);
        this.hasData = this.updateLightLevels((class_1937)mc.field_1687, pos);
        this.renderThrough = Configs.Generic.LIGHT_LEVEL_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.lastUpdatePos = pos;
        this.lastDirection = entity.method_5735();
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.lightInfos.isEmpty();
    }

    @Override
    public void allocateBuffers() {
        if (this.renderObjects.isEmpty()) {
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Quads", MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH_NO_CULL));
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH));
        }
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderTexQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderTexQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("light_level_quads");
        int safeThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        int dimThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_DIM.getIntegerValue();
        class_2350 numberFacing = Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() ? mc.field_1724.method_5735() : class_2350.field_11043;
        boolean useColoredNumbers = Configs.Generic.LIGHT_LEVEL_COLORED_NUMBERS.getBooleanValue();
        LightLevelNumberMode numberMode = (LightLevelNumberMode)Configs.Generic.LIGHT_LEVEL_NUMBER_MODE.getOptionListValue();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:light_level/tex_quads", this.renderThrough ? MaLiLibPipelines.POSITION_TEX_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH_NO_CULL);
        class_4587 matrices = new class_4587();
        try {
            ctx.bindTexture(TEXTURE_NUMBERS, 0, 256, 256);
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("bindTexture Exception: {}", (Object)err.getMessage());
            return;
        }
        matrices.method_22903();
        class_4587.class_4665 e = matrices.method_23760();
        if (numberMode == LightLevelNumberMode.BLOCK || numberMode == LightLevelNumberMode.BOTH) {
            this.renderNumbers(cameraPos, LightLevelNumberMode.BLOCK, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, builder, e);
        }
        if (numberMode == LightLevelNumberMode.SKY || numberMode == LightLevelNumberMode.BOTH) {
            this.renderNumbers(cameraPos, LightLevelNumberMode.SKY, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, builder, e);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererLightLevel#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("light_level_outlines");
        int safeThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        int dimThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_DIM.getIntegerValue();
        LightLevelMarkerMode markerMode = (LightLevelMarkerMode)Configs.Generic.LIGHT_LEVEL_MARKER_MODE.getOptionListValue();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:light_level/outlines", this.renderThrough ? MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL : MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        if (markerMode == LightLevelMarkerMode.SQUARE) {
            this.renderMarkers(this::renderLightLevelSquare, cameraPos, safeThreshold, dimThreshold, builder);
        } else if (markerMode == LightLevelMarkerMode.CROSS) {
            this.renderMarkers(this::renderLightLevelCross, cameraPos, safeThreshold, dimThreshold, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererLightLevel#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.tagsBroken = false;
        this.lightInfos.clear();
        this.mutablePos = new class_2338.class_2339();
        this.lastDirection = class_2350.field_11043;
        this.hasData = false;
    }

    private void renderNumbers(class_243 cameraPos, LightLevelNumberMode mode, IConfigDouble cfgOffX, IConfigDouble cfgOffZ, ConfigColor cfgColorLit, ConfigColor cfgColorDim, ConfigColor cfgColorDark, boolean useColoredNumbers, int safeThreshold, int dimThreshold, class_2350 numberFacing, class_287 buffer, class_4587.class_4665 e) {
        Color4f colorDark;
        Color4f colorDim;
        Color4f colorLit;
        double tmpX;
        double ox = cfgOffX.getDoubleValue();
        double oz = cfgOffZ.getDoubleValue();
        double offsetY = Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double tmpZ = switch (numberFacing) {
            case class_2350.field_11043 -> {
                tmpX = -ox;
                yield -oz;
            }
            case class_2350.field_11035 -> {
                tmpX = ox;
                yield oz;
            }
            case class_2350.field_11039 -> {
                tmpX = -oz;
                yield ox;
            }
            case class_2350.field_11034 -> {
                tmpX = oz;
                yield -ox;
            }
            default -> {
                tmpX = -ox;
                yield -oz;
            }
        };
        if (useColoredNumbers) {
            colorLit = cfgColorLit.getColor();
            colorDim = cfgColorDim.getColor();
            colorDark = cfgColorDark.getColor();
        } else {
            colorDim = colorLit = Color4f.fromColor((int)-1);
            colorDark = colorLit;
        }
        this.renderLightLevelNumbers(tmpX + cameraPos.field_1352, cameraPos.field_1351 - offsetY, tmpZ + cameraPos.field_1350, numberFacing, safeThreshold, dimThreshold, mode, colorLit, colorDim, colorDark, buffer, e);
    }

    private void renderMarkers(IMarkerRenderer renderer, class_243 cameraPos, int safeThreshold, int dimThreshold, class_287 buffer) {
        Color4f colorBlockLit = Configs.Colors.LIGHT_LEVEL_MARKER_BLOCK_LIT.getColor();
        Color4f colorDim = Configs.Colors.LIGHT_LEVEL_MARKER_DIM.getColor();
        Color4f colorSkyLit = Configs.Colors.LIGHT_LEVEL_MARKER_SKY_LIT.getColor();
        Color4f colorDark = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_MARKER_CONDITION.getOptionListValue();
        double markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
        double offsetX = cameraPos.field_1352;
        double offsetY = cameraPos.field_1351 - Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double offsetZ = cameraPos.field_1350;
        double offset1 = (1.0 - markerSize) / 2.0;
        double offset2 = 1.0 - offset1;
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)class_2338.method_10061((long)pos) - offsetX;
            double y = (double)(autoHeight ? info.y : (float)class_2338.method_10071((long)pos)) - offsetY;
            double z = (double)class_2338.method_10083((long)pos) - offsetZ;
            Color4f color = info.block < safeThreshold ? (info.sky >= safeThreshold ? colorSkyLit : colorDark) : (info.block > dimThreshold ? colorBlockLit : colorDim);
            renderer.render((float)x, (float)y, (float)z, color, (float)offset1, (float)offset2, buffer);
        }
    }

    private void renderLightLevelNumbers(double dx, double dy, double dz, class_2350 facing, int safeThreshold, int dimThreshold, LightLevelNumberMode numberMode, Color4f colorLit, Color4f colorDim, Color4f colorDark, class_287 buffer, class_4587.class_4665 e) {
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_NUMBER_CONDITION.getOptionListValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            byte lightLevel;
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)class_2338.method_10061((long)pos) - dx;
            double y = (double)(autoHeight ? info.y : (float)class_2338.method_10071((long)pos)) - dy;
            double z = (double)class_2338.method_10083((long)pos) - dz;
            byte by = lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
            Color4f color = lightLevel < safeThreshold ? colorDark : (lightLevel > dimThreshold ? colorLit : colorDim);
            this.renderLightLevelTextureColor((float)x, (float)y, (float)z, facing, lightLevel, color, buffer, e);
        }
    }

    private void renderLightLevelTextureColor(float x, float y, float z, class_2350 facing, int lightLevel, Color4f color, class_287 buffer, class_4587.class_4665 e) {
        float w = 0.25f;
        float u = (float)(lightLevel & 3) * w;
        float v = (float)(lightLevel >> 2) * w;
        y += 0.005f;
        Matrix4f m = e.method_23761();
        switch (facing) {
            case field_11043: {
                buffer.method_22918(m, x, y, z).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z + 1.0f).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z + 1.0f).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22918(m, x + 1.0f, y, z + 1.0f).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z + 1.0f).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22918(m, x + 1.0f, y, z).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z + 1.0f).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z + 1.0f).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11039: {
                buffer.method_22918(m, x, y, z + 1.0f).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z + 1.0f).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x + 1.0f, y, z).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22918(m, x, y, z).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
        }
    }

    private void renderLightLevelCross(float x, float y, float z, Color4f color, float offset1, float offset2, class_287 buffer) {
        buffer.method_22912(x + offset1, y += 0.005f, z + offset1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a);
    }

    private void renderLightLevelSquare(float x, float y, float z, Color4f color, float offset1, float offset2, class_287 buffer) {
        buffer.method_22912(x + offset1, y += 0.005f, z + offset1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x + offset1, y, z + offset1).method_22915(color.r, color.g, color.b, color.a);
    }

    private boolean updateLightLevels(class_1937 world, class_2338 center) {
        this.lightInfos.clear();
        int radius = Configs.Generic.LIGHT_LEVEL_RANGE.getIntegerValue();
        int minX = center.method_10263() - radius;
        int minY = center.method_10264() - radius;
        int minZ = center.method_10260() - radius;
        int maxX = center.method_10263() + radius;
        int maxY = center.method_10264() + radius;
        int maxZ = center.method_10260() + radius;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        class_3568 lightingProvider = world.method_8398().method_12130();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int worldTopHeight = world.method_31600() + 1;
        boolean collisionCheck = Configs.Generic.LIGHT_LEVEL_COLLISION_CHECK.getBooleanValue();
        boolean underWater = Configs.Generic.LIGHT_LEVEL_UNDER_WATER.getBooleanValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        boolean skipBlockCheck = Configs.Generic.LIGHT_LEVEL_SKIP_BLOCK_CHECK.getBooleanValue();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            int startX = Math.max(cx << 4, minX);
            int endX = Math.min((cx << 4) + 15, maxX);
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                int startZ = Math.max(cz << 4, minZ);
                int endZ = Math.min((cz << 4) + 15, maxZ);
                class_2818 chunk = world.method_8497(cx, cz);
                int startY = Math.max(minY, world.method_31607());
                int endY = Math.min(maxY, WorldUtils.getHighestSectionYOffset((class_2791)chunk) + 15 + 1);
                for (int y = startY; y <= endY; ++y) {
                    class_2826 section;
                    if (y > startY && (section = chunk.method_38259(chunk.method_31602(y - 1))).method_38292()) continue;
                    for (int x = startX; x <= endX; ++x) {
                        for (int z = startZ; z <= endZ; ++z) {
                            if (!this.canSpawnAtWrapper(x, y, z, (class_2791)chunk, world, skipBlockCheck)) continue;
                            mutablePos.method_10103(x, y, z);
                            class_2680 state = chunk.method_8320((class_2338)mutablePos);
                            if (collisionCheck && !state.method_26220((class_1922)chunk, (class_2338)mutablePos).method_1110() || !underWater && !state.method_26227().method_15769()) continue;
                            int block = y < worldTopHeight ? lightingProvider.method_15562(class_1944.field_9282).method_15543((class_2338)mutablePos) : 0;
                            int sky = y < worldTopHeight ? lightingProvider.method_15562(class_1944.field_9284).method_15543((class_2338)mutablePos) : 15;
                            double topY = state.method_26218((class_1922)chunk, (class_2338)mutablePos).method_1105(class_2350.class_2351.field_11052);
                            if (autoHeight && !(topY < 1.0)) continue;
                            float posY = topY >= 0.0 ? (float)y + (float)topY : (float)y;
                            this.lightInfos.add(new LightLevelInfo(mutablePos.method_10063(), posY, block, sky));
                        }
                    }
                }
            }
        }
        return !this.lightInfos.isEmpty();
    }

    private boolean canSpawnAtWrapper(int x, int y, int z, class_2791 chunk, class_1937 world, boolean skipBlockCheck) {
        try {
            return this.canSpawnAt(x, y, z, chunk, world, skipBlockCheck);
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"This dimension seems to have missing block tag data, the light level will not use the normal block spawnability checks in this dimension. This is known to happen on some Waterfall/BungeeCord/ViaVersion/whatever setups that have an older MC version at the back end.", (Object[])new Object[0]);
            this.tagsBroken = true;
            return false;
        }
    }

    private boolean canSpawnAt(int x, int y, int z, class_2791 chunk, class_1937 world, boolean skipBlockCheck) {
        this.mutablePos.method_10103(x, y - 1, z);
        class_2680 stateDown = chunk.method_8320((class_2338)this.mutablePos);
        if (skipBlockCheck && !stateDown.method_26215() && !(stateDown.method_26204() instanceof class_2404) || stateDown.method_26170((class_1922)world, (class_2338)this.mutablePos, class_1299.field_6046)) {
            this.mutablePos.method_10103(x, y, z);
            class_2680 state = chunk.method_8320((class_2338)this.mutablePos);
            if (this.isClearForSpawnWrapper((class_1922)world, (class_2338)this.mutablePos, state, state.method_26227(), class_1299.field_6076)) {
                this.mutablePos.method_10103(x, y + 1, z);
                class_2680 stateUp1 = chunk.method_8320((class_2338)this.mutablePos);
                return this.isClearForSpawnWrapper((class_1922)world, (class_2338)this.mutablePos, stateUp1, state.method_26227(), class_1299.field_6076);
            }
            if (state.method_26227().method_15767(class_3486.field_15517)) {
                this.mutablePos.method_10103(x, y + 1, z);
                class_2680 stateUp1 = chunk.method_8320((class_2338)this.mutablePos);
                return stateUp1.method_26227().method_15767(class_3486.field_15517) && !chunk.method_8320((class_2338)this.mutablePos.method_10103(x, y + 2, z)).method_26212((class_1922)world, (class_2338)this.mutablePos);
            }
        }
        return false;
    }

    public boolean isClearForSpawnWrapper(class_1922 blockView, class_2338 pos, class_2680 state, class_3610 fluidState, class_1299<?> entityType) {
        return this.tagsBroken ? OverlayRendererLightLevel.isClearForSpawnStripped(blockView, pos, state, fluidState, entityType) : class_1948.method_8662((class_1922)blockView, (class_2338)pos, (class_2680)state, (class_3610)fluidState, entityType);
    }

    public static boolean isClearForSpawnStripped(class_1922 blockView, class_2338 pos, class_2680 state, class_3610 fluidState, class_1299<?> entityType) {
        if (state.method_26234(blockView, pos) || state.method_26219() || !fluidState.method_15769()) {
            return false;
        }
        if (state.method_26164(class_3481.field_40107)) {
            return false;
        }
        return !entityType.method_29496(state);
    }

    private static interface IMarkerRenderer {
        public void render(float var1, float var2, float var3, Color4f var4, float var5, float var6, class_287 var7);
    }

    public static class LightLevelInfo {
        public long pos;
        public byte block;
        public byte sky;
        public float y;

        public LightLevelInfo(long pos, float y, int block, int sky) {
            this.pos = pos;
            this.y = y;
            this.block = (byte)block;
            this.sky = (byte)sky;
        }
    }
}

